  PROGRAM

_HtmlEditDllMode_               Equate(0)
_HtmlEditLinkMode_              Equate(1)

UINT                            Equate(UNSIGNED)
LPARAM                          Equate(LONG)
HANDLE                          Equate(UINT)
HWND                            Equate(HANDLE)
HDC                             Equate(HANDLE)

COMMAND:BOLD                    Equate(5000)
COMMAND:COPY                    Equate(5002)
COMMAND:CUT                     Equate(5003)
COMMAND:DELETE                  Equate(5004)
COMMAND:DELETECELLS             Equate(5005)
COMMAND:DELETECOLS              Equate(5006)
COMMAND:DELETEROWS              Equate(5007)
COMMAND:FINDTEXT                Equate(5008)
COMMAND:FONT                    Equate(5009)
COMMAND:GETBACKCOLOR            Equate(5010)
COMMAND:GETBLOCKFMT             Equate(5011)
COMMAND:GETBLOCKFMTNAMES        Equate(5012)
COMMAND:GETFONTNAME             Equate(5013)
COMMAND:GETFONTSIZE             Equate(5014)
COMMAND:GETFORECOLOR            Equate(5015)
COMMAND:HYPERLINK               Equate(5016)
COMMAND:IMAGE                   Equate(5017)
COMMAND:INDENT                  Equate(5018)
COMMAND:INSERTCELL              Equate(5019)
COMMAND:INSERTCOL               Equate(5020)
COMMAND:INSERTROW               Equate(5021)
COMMAND:INSERTTABLE             Equate(5022)
COMMAND:ITALIC                  Equate(5023)
COMMAND:JUSTIFYCENTER           Equate(5024)
COMMAND:JUSTIFYLEFT             Equate(5025)
COMMAND:JUSTIFYRIGHT            Equate(5026)
COMMAND:LOCK_ELEMENT            Equate(5027)
COMMAND:MAKE_ABSOLUTE           Equate(5028)
COMMAND:MERGECELLS              Equate(5029)
COMMAND:ORDERLIST               Equate(5030)
COMMAND:OUTDENT                 Equate(5031)
COMMAND:PASTE                   Equate(5032)
COMMAND:REDO                    Equate(5033)
COMMAND:REMOVEFORMAT            Equate(5034)
COMMAND:SELECTALL               Equate(5035)
COMMAND:SEND_BACKWARD           Equate(5036)
COMMAND:BRING_FORWARD           Equate(5037)
COMMAND:SEND_BELOW_TEXT         Equate(5038)
COMMAND:BRING_ABOVE_TEXT        Equate(5039)
COMMAND:SEND_TO_BACK            Equate(5040)
COMMAND:BRING_TO_FRONT          Equate(5041)
COMMAND:SETBACKCOLOR            Equate(5042)
COMMAND:SETBLOCKFMT             Equate(5043)
COMMAND:SETFONTNAME             Equate(5044)
COMMAND:SETFONTSIZE             Equate(5045)
COMMAND:SETFORECOLOR            Equate(5046)
COMMAND:SPLITCELL               Equate(5047)
COMMAND:UNDERLINE               Equate(5048)
COMMAND:UNDO                    Equate(5049)
COMMAND:UNLINK                  Equate(5050)
COMMAND:UNORDERLIST             Equate(5051)
COMMAND:PROPERTIES              Equate(5052)

OLECMDEXECOPT_DODEFAULT         Equate(0)
OLECMDEXECOPT_PROMPTUSER        Equate(1)
OLECMDEXECOPT_DONTPROMPTUSER    Equate(2)

OLE_TRISTATE_UNCHECKED          Equate(0)
OLE_TRISTATE_CHECKED            Equate(1)
OLE_TRISTATE_GRAY               Equate(2)
                                
  INCLUDE('EQUATES.CLW'),ONCE
  INCLUDE('ERRORS.CLW'),ONCE
  INCLUDE('KEYCODES.CLW'),ONCE
  INCLUDE('HTMLEDIT.EQU'),ONCE

  MAP
    Module('font.c')
      EnumProc(*GROUP,*GROUP,SIGNED,LPARAM),SIGNED,PASCAL,RAW,Name('EnumProc')
    End

    Module ('win32api')
      GetDC(HWND),HDC,PASCAL,NAME('GetDC')
      ReleaseDC(HWND,HDC),SIGNED,PASCAL,PROC,NAME('ReleaseDC')
      FontEnumProc(*GROUP,*GROUP,SIGNED,LPARAM),SIGNED,PASCAL,RAW,TYPE
      EnumFontFamilies(HDC,LONG,FontEnumProc,LPARAM),SIGNED,PASCAL,RAW,PROC,NAME('EnumFontFamiliesA')
    End

    SetFontQueue(*CSTRING)
    ControlEventHandler(*SHORT Ref,SIGNED OLEControlFEQ,LONG OLEEvent),LONG

    INCLUDE('OCX.CLW'),ONCE
  END

  Include('HTMLEDIT.INC')

cbFontsQueue FontsQueueType

heLibraryInitialized  BYTE

  CODE
  RETURN

!===================== Public Methods ==========================================

HtmlEditClass.Init PROCEDURE(Window TheWindow,LONG ControlLabel,LONG ToolbarLabel,LONG ParentControlLabel,BYTE DebugMode = FALSE)
LOC:lX       LONG
LOC:lY       LONG
LOC:lWidth   LONG
LOC:lHeight  LONG
LOC:lParent  LONG

  CODE
  
  heLibraryInitialized = TRUE
  
  SELF.ToolbarLabel = ToolbarLabel
  SELF.ToolbarLabel{PROP:Hide} = TRUE

  LOC:lParent = ParentControlLabel !ControlLabel{PROP:Parent}
  
  LOC:lX      = ControlLabel{PROP:XPos}
  LOC:lY      = ControlLabel{PROP:YPos}
  LOC:lWidth  = ControlLabel{PROP:Width}
  LOC:lHeight = ControlLabel{PROP:Height}

  Destroy(ControlLabel)

  SELF.OleObject = Create(ControlLabel,CREATE:Ole,LOC:lParent)
  IF ~SELF.OleObject then Return End

  SELF.OleObject{PROP:Create} = 'DHTMLEdit.DHTMLEdit.1'
  SELF.OleObject{PROP:Hide} = FALSE

  If DebugMode = TRUE
    SELF.OleObject{PROP:ReportException} = TRUE
  End

  SELF.OleObject{PROP:Compatibility} = 0

  SELF.OleObject{PROP:XPos}   = LOC:lX
  SELF.OleObject{PROP:YPos}   = LOC:lY
  SELF.OleObject{PROP:Width}  = LOC:lWidth
  SELF.OleObject{PROP:Height} = LOC:lHeight

  OcxRegisterEventProc(SELF.OleObject,ControlEventHandler)

  Select(LOC:lParent)

  SELF.CreateNewDocument()

  SELF.Initialized = TRUE

  RETURN
!-------------------------------------------------------------------------------

HtmlEditClass.Kill PROCEDURE(BYTE SaveIfModified = FALSE)
  CODE
  If ~SELF.Initialized then Return End

  If SaveIfModified = TRUE
    If SELF.Modified()
      Case Message('The document has been modified, Save ?','Request',ICON:Question,BUTTON:Yes + BUTTON:No,BUTTON:Yes,0)
      Of BUTTON:Yes
        SELF.SaveToFile()
      End
    End
  End

  SELF.OleObject{PROP:Deactivate}

  RETURN
!-------------------------------------------------------------------------------

HtmlEditClass.SetToolbar PROCEDURE(<BYTE TheState>)
ToolbarPosition       LONG,PROTECTED
ToolbarHeight         LONG,PROTECTED
ControlPosition       LONG,PROTECTED
  CODE
  If ~SELF.Initialized then Return End

  If Omitted(2)
    If SELF.ToolbarLabel{PROP:Visible} = TRUE
      Do SetToolbarOff
    Else
      Do SetToolbarOn
    End
  Else
    If TheState = TRUE
      If SELF.ToolbarLabel{PROP:Visible} = FALSE
        Do SetToolbarOn
      End
    Else
      If SELF.ToolbarLabel{PROP:Visible} = TRUE
        Do SetToolbarOff
      End
    End
  End

  RETURN

SetToolbarOn   ROUTINE
  SELF.OleObject{PROP:Height}  = (SELF.OleObject{PROP:YPos} + SELF.OleObject{PROP:Height}) - (SELF.ToolbarLabel{PROP:YPos} + SELF.ToolbarLabel{PROP:Height} + 2)
  SELF.OleObject{PROP:YPos}    = SELF.ToolbarLabel{PROP:YPos} + SELF.ToolbarLabel{PROP:Height} + 2
  SELF.ToolbarLabel{PROP:Hide} = FALSE

SetToolbarOff  ROUTINE
  SELF.ToolbarLabel{PROP:Hide} = TRUE
  SELF.OleObject{PROP:Height}  = (SELF.OleObject{PROP:YPos} + SELF.OleObject{PROP:Height}) - SELF.ToolbarLabel{PROP:YPos} - 4
  SELF.OleObject{PROP:YPos}    = SELF.ToolbarLabel{PROP:YPos} + 4
!-------------------------------------------------------------------------------

HtmlEditClass.SetWorkMode PROCEDURE(BYTE TheMode)
  CODE
  If ~SELF.Initialized then Return End

  Case TheMode
  Of heWORKMODE:Browse
    SELF.SetProperty('BrowseMode',TRUE)
  Of heWORKMODE:Edit
    SELF.SetProperty('BrowseMode',FALSE)
  Else
    SELF.SetProperty('BrowseMode',TRUE)
  End

  RETURN
!-------------------------------------------------------------------------------

HtmlEditClass.SetContent PROCEDURE(STRING Content)
  CODE
  If ~SELF.Initialized then Return End

  SELF.SetProperty('DocumentHTML',Content)

  RETURN
!-------------------------------------------------------------------------------

HtmlEditClass.FilterSourceCode PROCEDURE(STRING Content)
  CODE
  If ~SELF.Initialized then Return('') End

  RETURN(SELF.ExecuteMethod('FilterSourceCode(' & Content & ')'))
!-------------------------------------------------------------------------------

HtmlEditClass.SetBevelType PROCEDURE(BYTE BevelType)
  CODE
  If ~SELF.Initialized then Return End

  SELF.SetProperty('Appearance',BevelType)

  RETURN
!-------------------------------------------------------------------------------

HtmlEditClass.SetBaseUrl PROCEDURE(STRING BaseUrl)
  CODE
  If ~SELF.Initialized then Return End

  SELF.SetProperty('BaseURL',BaseUrl)

  RETURN
!-------------------------------------------------------------------------------

HtmlEditClass.Busy PROCEDURE()
  CODE
  If ~SELF.Initialized then Return(-1) End

  RETURN(Abs(SELF.GetProperty('Busy')))
!-------------------------------------------------------------------------------

HtmlEditClass.GetDocumentPath PROCEDURE()
  CODE
  If ~SELF.Initialized then Return('') End

  RETURN(SELF.GetProperty('CurrentDocumentPath'))
!-------------------------------------------------------------------------------

HtmlEditClass.GetContent PROCEDURE
  CODE
  If ~SELF.Initialized then Return('') End

  RETURN(SELF.GetProperty('DocumentHTML'))
!-------------------------------------------------------------------------------

HtmlEditClass.GetTitle PROCEDURE()
  CODE
  If ~SELF.Initialized then Return('') End

  RETURN(SELF.GetProperty('DocumentTitle'))
!-------------------------------------------------------------------------------

HtmlEditClass.Modified PROCEDURE()
  CODE
  If ~SELF.Initialized then Return(-1) End

  RETURN(Abs(SELF.GetProperty('IsDirty')))
!-------------------------------------------------------------------------------

HtmlEditClass.SetScrollBar PROCEDURE(BYTE Appearance)
  CODE
  If ~SELF.Initialized then Return End

  SELF.SetProperty('ScrollbarAppearance',Appearance)

  RETURN
!-------------------------------------------------------------------------------

HtmlEditClass.SetScrollBars PROCEDURE(BYTE TheState)
  CODE
  If ~SELF.Initialized then Return End

  SELF.SetProperty('ScrollBars',TheState)

  RETURN
!-------------------------------------------------------------------------------

HtmlEditClass.SetBorders PROCEDURE(BYTE BorderType)
  CODE
  If ~SELF.Initialized then Return End

  SELF.SetProperty('ShowBorders',BorderType)

  RETURN
!-------------------------------------------------------------------------------

HtmlEditClass.ShowDetails PROCEDURE(BYTE TheMode)
  CODE
  If ~SELF.Initialized then Return End

  SELF.SetProperty('ShowDetails',TheMode)

  RETURN
!-------------------------------------------------------------------------------

HtmlEditClass.SetSnapToGrid PROCEDURE(BYTE TheMode)
  CODE
  If ~SELF.Initialized then Return End

  SELF.SetProperty('SnapToGrid',TheMode)

  RETURN
!-------------------------------------------------------------------------------

HtmlEditClass.SetSnapToGridX PROCEDURE(LONG X)
  CODE
  If ~SELF.Initialized then Return End

  SELF.SetProperty('SnapToGridX',X)

  RETURN
!-------------------------------------------------------------------------------

HtmlEditClass.SetSnapToGridY PROCEDURE(LONG Y)
  CODE
  If ~SELF.Initialized then Return End

  SELF.SetProperty('SnapToGridY',Y)

  RETURN
!-------------------------------------------------------------------------------

HtmlEditClass.SetCodePreservation PROCEDURE(BYTE TheMode)
  CODE
  If ~SELF.Initialized then Return End

  SELF.SetProperty('SourceCodePreservation',TheMode)

  RETURN
!-------------------------------------------------------------------------------

HtmlEditClass.SetSpacingMode PROCEDURE(BYTE TheMode)
  CODE
  If ~SELF.Initialized then Return End

  SELF.SetProperty('UseDivOnCarriageReturn',TheMode)

  RETURN
!-------------------------------------------------------------------------------

HtmlEditClass.SetAbsuluteDropMode PROCEDURE(BYTE TheMode)
  CODE
  If ~SELF.Initialized then Return End

  SELF.SetProperty('AbsoluteDropMode',TheMode)

  RETURN
!-------------------------------------------------------------------------------

HtmlEditClass.LoadFromFile PROCEDURE(<STRING FileName>)
LOC:strFileName    String(255)
  CODE
  If ~SELF.Initialized then Return(-1) End

  LOC:strFileName = FileName

  If LOC:strFileName = ''
    z# = FileDialog('Open HTML Document',LOC:strFileName,'HTML Documents|*.html|',FILE:KeepDir + FILE:LongName)
    If ~z# Or ~LOC:strFileName
      Return(0)
    End
  End

  RETURN(SELF.ExecuteMethod('LoadDocument("' & Clip(LOC:strFileName) & '",0)'))
!-------------------------------------------------------------------------------

HtmlEditClass.LoadFromBlob PROCEDURE(*BLOB TheField)
LOC:lBlobSize   Long
LOC:strContent  &String
  CODE
  If ~SELF.Initialized then Return End

  LOC:lBlobSize   = TheField{PROP:Size}
  LOC:strContent &= New(String(LOC:lBlobSize + 1))
    
  SELF.PutBlobToVar(TheField,LOC:strContent)
  SELF.SetContent(LOC:strContent)

  Dispose(LOC:strContent)

  RETURN
!-------------------------------------------------------------------------------

HtmlEditClass.LoadFromMemo PROCEDURE(*? TheField)
  CODE
  If ~SELF.Initialized then Return End

  SELF.SetContent(TheField)

  RETURN
!-------------------------------------------------------------------------------

HtmlEditClass.SaveToBlob PROCEDURE(*BLOB TheField)
  CODE
  If ~SELF.Initialized then Return End
  
  SELF.PutVarToBlob(TheField,SELF.GetContent())

  RETURN
!-------------------------------------------------------------------------------

HtmlEditClass.SaveTomemo PROCEDURE(*? TheField)
  CODE
  If ~SELF.Initialized then Return End
  
  TheField = SELF.GetContent()

  RETURN
!-------------------------------------------------------------------------------

HtmlEditClass.LoadURL PROCEDURE(STRING URL)
  CODE
  If ~SELF.Initialized then Return(-1) End

  RETURN(SELF.ExecuteMethod('LoadURL("' & Clip(URL) & '")'))
!-------------------------------------------------------------------------------

HtmlEditClass.CreateNewDocument PROCEDURE()
  CODE
  If ~SELF.Initialized then Return(-1) End

  SELF.SelectAll()
  SELF.SetFontSize(2)

  RETURN(SELF.ExecuteMethod('NewDocument'))
!-------------------------------------------------------------------------------

HtmlEditClass.PrintDocument PROCEDURE(BYTE DisplayDialog)
  CODE
  If ~SELF.Initialized then Return(-1) End

  RETURN(SELF.ExecuteMethod('PrintDocument(' & DisplayDialog & ')'))
!-------------------------------------------------------------------------------

HtmlEditClass.Allowed PROCEDURE(LONG Command)
  CODE
  If ~SELF.Initialized then Return(-1) End

  RETURN(SELF.ExecuteMethod('QueryStatus(' & Command & ')'))
!-------------------------------------------------------------------------------

HtmlEditClass.RefreshDocument PROCEDURE()
  CODE
  If ~SELF.Initialized then Return(-1) End

  RETURN(SELF.ExecuteMethod('Refresh'))
!-------------------------------------------------------------------------------

HtmlEditClass.SaveToFile PROCEDURE(<STRING FileName>)
LOC:strFileName    String(255)
  CODE
  If ~SELF.Initialized then Return(-1) End

  LOC:strFileName = FileName

  If LOC:strFileName = ''
    z# = FileDialog('Save Document',LOC:strFileName,'HTML Documents|*.html|',FILE:Save + FILE:KeepDir + FILE:LongName)
    If ~z# Or ~LOC:strFileName
      Return(0)
    End
  End

  If Sub(Clip(LOC:strFileName),-5,5) <> '.html'
    LOC:strFileName = Clip(LOC:strFileName) & '.html'
  End

  RETURN(SELF.ExecuteMethod('SaveDocument("' & Clip(LOC:strFileName) & '",0)'))
!-------------------------------------------------------------------------------

HtmlEditClass.Bold PROCEDURE()
  CODE
  If ~SELF.Initialized then Return(-1) End
  If ~SELF.Allowed(COMMAND:BOLD) then Return(-1) End

  RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:BOLD & ')'))
!-------------------------------------------------------------------------------

HtmlEditClass.Copy PROCEDURE()
  CODE
  If ~SELF.Initialized then Return(-1) End
  If ~SELF.Allowed(COMMAND:COPY) then Return(-1) End

  RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:COPY & ')'))
!-------------------------------------------------------------------------------

HtmlEditClass.Cut PROCEDURE()
  CODE
  If ~SELF.Initialized then Return(-1) End
  If ~SELF.Allowed(COMMAND:CUT) then Return(-1) End

  RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:CUT & ')'))
!-------------------------------------------------------------------------------

HtmlEditClass.Delete PROCEDURE()
  CODE
  If ~SELF.Initialized then Return(-1) End
  If ~SELF.Allowed(COMMAND:DELETE) then Return(-1) End

  RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:DELETE & ')'))
!-------------------------------------------------------------------------------

HtmlEditClass.FindText PROCEDURE()
  CODE
  If ~SELF.Initialized then Return(-1) End
  If ~SELF.Allowed(COMMAND:FINDTEXT) then Return(-1) End

  RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:FINDTEXT & ')'))
!-------------------------------------------------------------------------------

HtmlEditClass.Font PROCEDURE()
  CODE
  If ~SELF.Initialized then Return(-1) End
  If ~SELF.Allowed(COMMAND:FONT) then Return(-1) End

  RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:FONT & ')'))
!-------------------------------------------------------------------------------

HtmlEditClass.GetBackColor PROCEDURE()
  CODE
  If ~SELF.Initialized then Return(-1) End
  If ~SELF.Allowed(COMMAND:GETBACKCOLOR) then Return(-1) End

  RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:GETBACKCOLOR & ')'))
!-------------------------------------------------------------------------------

HtmlEditClass.GetBlockFmt PROCEDURE()
  CODE
  If ~SELF.Initialized then Return(-1) End
  If ~SELF.Allowed(COMMAND:GETBLOCKFMT) then Return(-1) End

  RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:GETBLOCKFMT & ')'))
!-------------------------------------------------------------------------------

HtmlEditClass.GetFontName PROCEDURE()
  CODE
  If ~SELF.Initialized then Return(-1) End
  If ~SELF.Allowed(COMMAND:GETFONTNAME) then Return(-1) End

  RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:GETFONTNAME & ')'))
!-------------------------------------------------------------------------------

HtmlEditClass.GetFontSize PROCEDURE()
  CODE
  If ~SELF.Initialized then Return(-1) End
  If ~SELF.Allowed(COMMAND:GETFONTSIZE) then Return(-1) End

  RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:GETFONTSIZE & ')'))
!-------------------------------------------------------------------------------

HtmlEditClass.GetForeColor PROCEDURE()
  CODE
  If ~SELF.Initialized then Return(-1) End
  If ~SELF.Allowed(COMMAND:GETFORECOLOR) then Return(-1) End

  RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:GETFORECOLOR & ')'))
!-------------------------------------------------------------------------------

HtmlEditClass.HyperLink PROCEDURE(BYTE RequestStatus = heREQUEST:Default,<STRING Url>)
LOC:bRequest Byte
  CODE
  If ~SELF.Initialized then Return(-1) End
  If ~SELF.Allowed(COMMAND:HYPERLINK) then Return(-1) End

  If ~Omitted(3)
    RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:HYPERLINK & ',' & RequestStatus & ',' & Clip(Url) & ')'))
  Else
    RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:HYPERLINK & ',' & RequestStatus & ')'))
  End
!-------------------------------------------------------------------------------

HtmlEditClass.Image PROCEDURE(BYTE RequestStatus = heREQUEST:Default,<STRING FileName>)
  CODE
  If ~SELF.Initialized then Return(-1) End
  If ~SELF.Allowed(COMMAND:IMAGE) then Return(-1) End

  If ~Omitted(3)
    RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:IMAGE & ',' & RequestStatus & ',' & Clip(FileName) & ')'))
  Else
    RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:IMAGE & ',' & RequestStatus & ')'))
  End
!-------------------------------------------------------------------------------

HtmlEditClass.Indent PROCEDURE()
  CODE
  If ~SELF.Initialized then Return(-1) End
  If ~SELF.Allowed(COMMAND:INDENT) then Return(-1) End

  RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:INDENT & ')'))
!-------------------------------------------------------------------------------

HtmlEditClass.Italic PROCEDURE()
  CODE
  If ~SELF.Initialized then Return(-1) End
  If ~SELF.Allowed(COMMAND:ITALIC) then Return(-1) End

  RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:ITALIC & ')'))
!-------------------------------------------------------------------------------

HtmlEditClass.JustifyCenter PROCEDURE()
  CODE
  If ~SELF.Initialized then Return(-1) End
  If ~SELF.Allowed(COMMAND:JUSTIFYCENTER) then Return(-1) End

  RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:JUSTIFYCENTER & ')'))
!-------------------------------------------------------------------------------

HtmlEditClass.JustifyLeft PROCEDURE()
  CODE
  If ~SELF.Initialized then Return(-1) End
  If ~SELF.Allowed(COMMAND:JUSTIFYLEFT) then Return(-1) End

  RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:JUSTIFYLEFT & ')'))
!-------------------------------------------------------------------------------

HtmlEditClass.JustifyRight PROCEDURE()
  CODE
  If ~SELF.Initialized then Return(-1) End
  If ~SELF.Allowed(COMMAND:JUSTIFYRIGHT) then Return(-1) End

  RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:JUSTIFYRIGHT & ')'))
!-------------------------------------------------------------------------------

HtmlEditClass.LockElement PROCEDURE()
  CODE
  If ~SELF.Initialized then Return(-1) End
  If ~SELF.Allowed(COMMAND:LOCK_ELEMENT) then Return(-1) End

  RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:LOCK_ELEMENT & ')'))
!-------------------------------------------------------------------------------

HtmlEditClass.MakeAbsolute PROCEDURE()
  CODE
  If ~SELF.Initialized then Return(-1) End
  If ~SELF.Allowed(COMMAND:MAKE_ABSOLUTE) then Return(-1) End

  RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:MAKE_ABSOLUTE & ')'))
!-------------------------------------------------------------------------------

HtmlEditClass.OrderList PROCEDURE()
  CODE
  If ~SELF.Initialized then Return(-1) End
  If ~SELF.Allowed(COMMAND:ORDERLIST) then Return(-1) End

  RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:ORDERLIST & ')'))
!-------------------------------------------------------------------------------

HtmlEditClass.Outdent PROCEDURE()
  CODE
  If ~SELF.Initialized then Return(-1) End
  If ~SELF.Allowed(COMMAND:OUTDENT) then Return(-1) End

  RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:OUTDENT & ')'))
!-------------------------------------------------------------------------------

HtmlEditClass.Paste PROCEDURE()
  CODE
  If ~SELF.Initialized then Return(-1) End
  If ~SELF.Allowed(COMMAND:PASTE) then Return(-1) End

  RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:PASTE & ')'))
!-------------------------------------------------------------------------------

HtmlEditClass.Redo PROCEDURE()
  CODE
  If ~SELF.Initialized then Return(-1) End
  If ~SELF.Allowed(COMMAND:REDO) then Return(-1) End

  RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:REDO & ')'))
!-------------------------------------------------------------------------------

HtmlEditClass.RemoveFormat PROCEDURE()
  CODE
  If ~SELF.Initialized then Return(-1) End
  If ~SELF.Allowed(COMMAND:REMOVEFORMAT) then Return(-1) End

  RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:REMOVEFORMAT & ')'))
!-------------------------------------------------------------------------------

HtmlEditClass.SelectAll PROCEDURE()
  CODE
  If ~SELF.Initialized then Return(-1) End
  If ~SELF.Allowed(COMMAND:SELECTALL) then Return(-1) End

  RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:SELECTALL & ')'))
!-------------------------------------------------------------------------------

HtmlEditClass.SendBackward PROCEDURE()
  CODE
  If ~SELF.Initialized then Return(-1) End
  If ~SELF.Allowed(COMMAND:SEND_BACKWARD) then Return(-1) End

  RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:SEND_BACKWARD & ')'))
!-------------------------------------------------------------------------------

HtmlEditClass.BringForward PROCEDURE()
  CODE
  If ~SELF.Initialized then Return(-1) End
  If ~SELF.Allowed(COMMAND:BRING_FORWARD) then Return(-1) End

  RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:BRING_FORWARD & ')'))
!-------------------------------------------------------------------------------

HtmlEditClass.SendBelowText PROCEDURE()
  CODE
  If ~SELF.Initialized then Return(-1) End
  If ~SELF.Allowed(COMMAND:SEND_BELOW_TEXT) then Return(-1) End

  RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:SEND_BELOW_TEXT & ')'))
!-------------------------------------------------------------------------------

HtmlEditClass.BringAboveText PROCEDURE()
  CODE
  If ~SELF.Initialized then Return(-1) End
  If ~SELF.Allowed(COMMAND:BRING_ABOVE_TEXT) then Return(-1) End

  RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:BRING_ABOVE_TEXT & ')'))
!-------------------------------------------------------------------------------

HtmlEditClass.SendToBack PROCEDURE()
  CODE
  If ~SELF.Initialized then Return(-1) End
  If ~SELF.Allowed(COMMAND:SEND_TO_BACK) then Return(-1) End

  RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:SEND_TO_BACK & ')'))
!-------------------------------------------------------------------------------

HtmlEditClass.BringToFront PROCEDURE()
  CODE
  If ~SELF.Initialized then Return(-1) End
  If ~SELF.Allowed(COMMAND:BRING_TO_FRONT) then Return(-1) End

  RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:BRING_TO_FRONT & ')'))
!-------------------------------------------------------------------------------

HtmlEditClass.SetBackColor PROCEDURE(<? BackColor>)
LOC:lColor  Long
  CODE
  If ~SELF.Initialized then Return(-1) End
  If ~SELF.Allowed(COMMAND:SETBACKCOLOR) then Return(-1) End

  If Omitted(2)
    If ~ColorDialog('Choose background color',LOC:lColor,1)
      Return(0)
    End
    RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:SETBACKCOLOR & ',' & OLECMDEXECOPT_DODEFAULT & ',' & LOC:lColor & ')'))
  Else
    RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:SETBACKCOLOR & ',' & OLECMDEXECOPT_DODEFAULT & ',' & BackColor & ')'))
  End
!-------------------------------------------------------------------------------

HtmlEditClass.SetForeColor PROCEDURE(<? ForeColor>)
LOC:lColor  Long
  CODE
  If ~SELF.Initialized then Return(-1) End
  If ~SELF.Allowed(COMMAND:SETFORECOLOR) then Return(-1) End

  If Omitted(2)
    If ~ColorDialog('Choose text color',LOC:lColor,1)
      Return(0)
    End
    RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:SETFORECOLOR & ',' & OLECMDEXECOPT_DODEFAULT & ',' & LOC:lColor & ')'))
  Else
    RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:SETFORECOLOR & ',' & OLECMDEXECOPT_DODEFAULT & ',' & ForeColor & ')'))
  End
!-------------------------------------------------------------------------------

HtmlEditClass.SetBlockFmt PROCEDURE(STRING FormatName)
  CODE
  If ~SELF.Initialized then Return(-1) End
  If ~SELF.Allowed(COMMAND:SETBLOCKFMT) then Return(-1) End

  RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:SETBLOCKFMT & ',' & OLECMDEXECOPT_DODEFAULT & ',' & Clip(FormatName) & ')'))
!-------------------------------------------------------------------------------

HtmlEditClass.SetFontName PROCEDURE(STRING FontName)
  CODE
  If ~SELF.Initialized then Return(-1) End
  If ~SELF.Allowed(COMMAND:SETFONTNAME) then Return(-1) End
  
  RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:SETFONTNAME & ',' & OLECMDEXECOPT_DODEFAULT & ',' & Clip(FontName) & ')'))
!-------------------------------------------------------------------------------

HtmlEditClass.SetFontSize PROCEDURE(BYTE FontSize)
  CODE
  If ~SELF.Initialized then Return(-1) End
  If ~SELF.Allowed(COMMAND:SETFONTSIZE) then Return(-1) End

  RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:SETFONTSIZE & ',' & OLECMDEXECOPT_DODEFAULT & ',' & Clip(FontSize) & ')'))
!-------------------------------------------------------------------------------

HtmlEditClass.IncreaseFontSize PROCEDURE()
LOC:bCurrentFontSize BYTE
  CODE
  If ~SELF.Initialized then Return(-1) End

  LOC:bCurrentFontSize = SELF.GetFontSize()

  If LOC:bCurrentFontSize = 7
    Return(0)
  Else
    LOC:bCurrentFontSize += 1
  End

  RETURN(SELF.SetFontSize(LOC:bCurrentFontSize))
!-------------------------------------------------------------------------------
HtmlEditClass.DecreaseFontSize PROCEDURE()
LOC:bCurrentFontSize BYTE
  CODE
  If ~SELF.Initialized then Return(-1) End

  LOC:bCurrentFontSize = SELF.GetFontSize()

  If LOC:bCurrentFontSize = 1
    Return(0)
  Else
    LOC:bCurrentFontSize -= 1
  End

  RETURN(SELF.SetFontSize(LOC:bCurrentFontSize))
!-------------------------------------------------------------------------------

HtmlEditClass.SetFormat PROCEDURE(<STRING FontName>,<BYTE FontStyle>,<BYTE FontSize>,<? FontColor>)
  CODE
  If ~SELF.Initialized then Return End

  If ~Omitted(2) And FontName <> ''
    SELF.SetFontName(FontName)
  End

  IF BAND(FontStyle,heFONTSTYLE:Bold) = heFONTSTYLE:Bold
    SELF.Bold()
  END
  IF BAND(FontStyle,heFONTSTYLE:Italic) = heFONTSTYLE:Italic
    SELF.Italic()
  END
  IF BAND(FontStyle,heFONTSTYLE:Underline) = heFONTSTYLE:Underline
    SELF.Underline()
  End

  If ~Omitted(4)
    If Inrange(FontSize,1,7)
      SELF.SetFontSize(FontSize)
    End
  End

  If ~Omitted(5)
    SELF.SetForeColor(FontColor)
  End

  RETURN
!-------------------------------------------------------------------------------

HtmlEditClass.Underline PROCEDURE()
  CODE
  If ~SELF.Initialized then Return(-1) End
  If ~SELF.Allowed(COMMAND:UNDERLINE) then Return(-1) End

  RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:UNDERLINE & ')'))
!-------------------------------------------------------------------------------

HtmlEditClass.Undo PROCEDURE()
  CODE
  If ~SELF.Initialized then Return(-1) End
  If ~SELF.Allowed(COMMAND:UNDO) then Return(-1) End

  RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:UNDO & ')'))
!-------------------------------------------------------------------------------

HtmlEditClass.UnLink PROCEDURE()
  CODE
  If ~SELF.Initialized then Return(-1) End
  If ~SELF.Allowed(COMMAND:UNLINK) then Return(-1) End

  RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:UNLINK & ')'))
!-------------------------------------------------------------------------------

HtmlEditClass.UnOrderList PROCEDURE()
  CODE
  If ~SELF.Initialized then Return(-1) End
  If ~SELF.Allowed(COMMAND:UNORDERLIST) then Return(-1) End

  RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:UNORDERLIST & ')'))
!-------------------------------------------------------------------------------

HtmlEditClass.Properties PROCEDURE()
  CODE
  If ~SELF.Initialized then Return(-1) End
  If ~SELF.Allowed(COMMAND:PROPERTIES) then Return(-1) End

  RETURN(SELF.ExecuteMethod('ExecCommand(' & COMMAND:PROPERTIES & ')'))
!-------------------------------------------------------------------------------

HtmlEditClass.Suspend PROCEDURE()
  CODE
  If ~SELF.Initialized then Return End
  If SuspendMode then Return End

  If heLibraryInitialized = TRUE
    SELF.Initialized = FALSE
  End

  SuspendMode      = TRUE

  RETURN
!-------------------------------------------------------------------------------

HtmlEditClass.Resume PROCEDURE()
  CODE
  If ~heLibraryInitialized then Return End
  If SELF.Initialized then Return End
  If ~SuspendMode then Return End

  If heLibraryInitialized = TRUE
    SELF.Initialized = TRUE
  End

  SuspendMode      = FALSE

  RETURN
!-------------------------------------------------------------------------------

HtmlEditClass.Suspended PROCEDURE()
  CODE
  RETURN(SuspendMode)
!-------------------------------------------------------------------------------

!===================== Protected Methods =======================================

HtmlEditClass.ExecuteMethod PROCEDURE(STRING Statement)
  CODE
  If ~Statement then Return(0) End

  RETURN(SELF.OleObject{Statement})
!-------------------------------------------------------------------------------

HtmlEditClass.SetProperty PROCEDURE(STRING Statement,? Value)
  CODE
  If ~Statement then Return End

  SELF.OleObject{Statement} = Value

  RETURN
!-------------------------------------------------------------------------------

HtmlEditClass.GetProperty PROCEDURE(STRING Statement)
  CODE
  If ~Statement then Return('') End

  Return(SELF.OleObject{Statement})
!-------------------------------------------------------------------------------

HtmlEditClass.PutBlobToVar PROCEDURE(*BLOB TheBlob,*? TheVariable)
  CODE

  TheVariable = TheBlob[0 : TheBlob{PROP:Size} - 1]

  Return
!-------------------------------------------------------------------------------

HtmlEditClass.PutVarToBlob PROCEDURE(*BLOB TheBlob,? TheVariable)
LOC:lVarLength LONG
  CODE

  LOC:lVarLength     = Len(Clip(TheVariable))
  TheBlob{PROP:Size} = LOC:lVarLength

  TheBlob[0 : LOC:lVarLength - 1] = Clip(TheVariable)

  Return
!-------------------------------------------------------------------------------

HtmlEditClass.FillFontsList PROCEDURE(FontsQueueType TheFontsQueue)
LOC:cstrEnumerated    cString('<0>')
LOC:lHDCDesktop       Long
LOC:lFamilyAddress    Long
LOC:lLoopCounter      Long

  CODE

  Free(TheFontsQueue)

  If Val(LOC:cstrEnumerated[1]) = 0
    LOC:lFamilyAddress = 0
  Else
    LOC:lFamilyAddress = Address(LOC:cstrEnumerated)
  End

  SetCursor(CURSOR:Wait)

  LOC:lHDCDeskTop = GetDC(0)
  EnumFontFamilies(LOC:lHDCDesktop,LOC:lFamilyAddress,EnumProc,Address(SetFontQueue))
  ReleaseDC(0,LOC:lHDCDesktop)

  Loop LOC:lLoopCounter = 1 To Records(cbFontsQueue)
    Get(cbFontsQueue,LOC:lLoopCounter)
    If Error()
      Message(Error())
      Break
    Else
      TheFontsQueue.FontName = cbFontsQueue.FontName
      Add(TheFontsQueue)
    End
  End

  Free(cbFontsQueue)

  SetCursor()

  Return
!-------------------------------------------------------------------------------

!==================== Module Procedures ========================================

SetFontQueue PROCEDURE(_FaceName)
  Code

  cbFontsQueue.FontName = _FaceName

  Get (cbFontsQueue,+cbFontsQueue.FontName)
  If Error()
    Add(cbFontsQueue,+cbFontsQueue.FontName)
  End
!-------------------------------------------------------------------------------

ControlEventHandler PROCEDURE(*SHORT Ref,SIGNED OLEControlFEQ,LONG OLEEvent)
 CODE

 If SuspendMode = FALSE
   Case OLEEvent
   Of 2
     Post(EVENT:Changed)
   Of 3
     Post(EVENT:MouseRightClick)
   End
 End

 Return(0)
!-------------------------------------------------------------------------------
