    PROGRAM

    INCLUDE('EQUATES.CLW'),ONCE
    INCLUDE('ERRORS.CLW'),ONCE
    INCLUDE('KEYCODES.CLW'),ONCE

    MAP
      SubClassProc(UNSIGNED LOC:hWnd,UNSIGNED LOC:usMsg,UNSIGNED LOC:WParam,LONG LOC:LParam),LONG,PASCAL

      MODULE('WinAPI')
        SetWindowLong(LONG,LONG,LONG),LONG,PASCAL,Name('SetWindowLongA')
        CallWindowProc(LONG,LONG,LONG,LONG,LONG),LONG,PASCAL,Name('CallWindowProcA')
        GetForegroundWindow(),LONG,Name('GetForegroundWindow')
        GetFocus(),LONG,Name('GetFocus')
        GetDlgItem(LONG hDlg,LONG nIDDlgItem),LONG,Pascal,Name('GetDlgItem')
        GetTopWindow(LONG hWnd),LONG,PASCAL,Name('GetTopWindow')
      End

      INCLUDE('OCX.CLW'),ONCE
    END

    INCLUDE('htmledit.equ')
    INCLUDE('htmledit.inc')
    INCLUDE('ckeys.inc')

EVENT:Hook         Equate(EVENT:User + 51)
EVENT:Copy         Equate(EVENT:User + 52)
EVENT:Cut          Equate(EVENT:User + 53)
EVENT:Paste        Equate(EVENT:User + 54)
EVENT:Delete       Equate(EVENT:User + 55)
EVENT:SelectAll    Equate(EVENT:User + 56)
EVENT:Undo         Equate(EVENT:User + 57)
EVENT:Redo         Equate(EVENT:User + 58)
EVENT:Save         Equate(EVENT:User + 59)

HtmlEdit           Class(HtmlEditclass)
                   End

FontsQueue         Queue
FontName             cString(32)
                   End

WindowHandle       LONG
OleHandle          LONG
dhtmlocx           string(1024)

FileName           String(255)

window WINDOW('Html Editor Demo'),AT(,,482,337),FONT('MS Sans Serif',8,,FONT:regular,CHARSET:CYRILLIC), |
         CENTER,IMM,ICON('Book.ico'),ALRT(EscKey),SYSTEM,GRAY,MAX,DOUBLE
       TOOLBAR,AT(0,0,,40)
         GROUP,AT(3,0,447,39),USE(?ToolbarGroup)
           BUTTON,AT(7,5,16,14),USE(?TbNew),SKIP,FLAT,MSG('New'),TIP('New'),ICON('RtfNew.ico')
           BUTTON,AT(23,5,16,14),USE(?TbOpen),SKIP,FLAT,MSG('Open'),TIP('Open'),ICON('RtfOpen.ico')
           BUTTON,AT(39,5,16,14),USE(?TbSave),SKIP,FLAT,MSG('Save'),TIP('Save'),ICON('RtfSave.ico')
           PANEL,AT(59,5,1,14),USE(?TbPanel1),BEVEL(-1,1)
           BUTTON,AT(63,5,16,14),USE(?TbPrint),SKIP,FLAT,MSG('Print'),TIP('Print'),ICON('RtfPrint.ico')
           PANEL,AT(81,5,1,14),USE(?TbPanel2),BEVEL(-1,1)
           BUTTON,AT(103,5,16,14),USE(?TbCopy),SKIP,FLAT,MSG('Copy'),TIP('Copy'),ICON('RtfCopy.ico')
           BUTTON,AT(119,5,16,14),USE(?TbCut),SKIP,FLAT,MSG('Cut'),TIP('Cut'),ICON('RtfCut.ico')
           BUTTON,AT(137,5,16,14),USE(?TbPaste),SKIP,FLAT,MSG('Paste'),TIP('Paste'),ICON('Rtfpaste.ico')
           PANEL,AT(157,5,1,14),USE(?TbPanel3),BEVEL(-1,1)
           BUTTON,AT(161,5,15,14),USE(?TbUndo),SKIP,FLAT,MSG('Undo'),TIP('Undo'),ICON('RtfUndo.ico')
           BUTTON,AT(177,5,15,14),USE(?TbRedo),SKIP,FLAT,MSG('Redo'),TIP('Redo'),ICON('Redo.ICO')
           PANEL,AT(197,5,1,14),USE(?TbPanel4),BEVEL(-1,1)
           BUTTON,AT(201,5,16,14),USE(?TbLink),SKIP,FLAT,MSG('Insert URL'),TIP('Insert URL'),ICON('RtfLink.ico')
           BUTTON,AT(217,5,16,14),USE(?TbImage),SKIP,FLAT,MSG('Insert Picture'),TIP('Insert Picture'), |
               ICON('RtfImage.ico')
           PANEL,AT(237,5,1,14),USE(?TbPanel5),BEVEL(-1,1)
           BUTTON,AT(241,5,16,14),USE(?TbFind),SKIP,FLAT,MSG('Find'),TIP('Find'),ICON('RtfFind.ico')
           PANEL,AT(261,5,1,14),USE(?TbPanel6),BEVEL(-1,1)
           BUTTON,AT(85,5,16,14),USE(?TbSelectAll),SKIP,FLAT,MSG('Select All'),TIP('Select All'),ICON('RtfSelectAll.ico')
           BUTTON,AT(265,5,16,14),USE(?TbProperties),SKIP,FLAT,MSG('Properties'),TIP('Properties'),ICON('RtfProperties.ico')
           BUTTON,AT(281,5,16,14),USE(?TbDelete),SKIP,FLAT,MSG('Delete'),TIP('Delete'),ICON('RtfDelete.ico')
           PANEL,AT(405,5,1,14),USE(?TbPanel7),BEVEL(-1,1)
           BUTTON,AT(429,5,17,14),USE(?TbLockElement),SKIP,FLAT,MSG('Lock'),TIP('Lock'),ICON('RtfLock.ico')
           PANEL,AT(297,21,1,14),USE(?TbPanel135),BEVEL(-1,1)
           BUTTON,AT(303,5,16,14),USE(?TbSendToBack),SKIP,FLAT,MSG('Send to back'),TIP('Send to back'), |
               ICON('RtfSendToBack.ico')
           BUTTON,AT(321,5,16,14),USE(?TbBringToFront),SKIP,FLAT,MSG('Bring to front'),TIP('Bring to front'), |
               ICON('RtfBringToFront.ico')
           BUTTON,AT(337,5,16,14),USE(?TbBringForward),SKIP,FLAT,MSG('Bring Forward'),TIP('Bring Forward'), |
               ICON('RtfBringForward.ico')
           BUTTON,AT(353,5,16,14),USE(?TbSendBackward),SKIP,FLAT,MSG('Send backward'),TIP('Send backward'), |
               ICON('RtfSendBackward.ico')
           BUTTON,AT(371,5,16,14),USE(?TbSendBehindText),SKIP,FLAT,MSG('Send behind text'),TIP('Send behind text'), |
               ICON('RtfsendBehindText.ico')
           BUTTON,AT(387,5,16,14),USE(?TbInFrontOfText),SKIP,FLAT,MSG('Send in front of text'),TIP('Send in front of text'), |
               ICON('RtfInFrontOfText.ico')
           PANEL,AT(297,5,1,14),USE(?TbPanel13:2),BEVEL(-1,1)
           LIST,AT(7,22,110,12),USE(?TbFontsList),SKIP,VSCROLL,DROP(10),FROM(FontsQueue)
           BUTTON,AT(119,21,16,14),USE(?TbIncreaseFontSize),SKIP,FLAT,MSG('Increase font size'),TIP('Increase font size'), |
               ICON('RtfMoreFontSize.ico')
           BUTTON,AT(137,21,16,14),USE(?TbDecreaseFontSize),SKIP,FLAT,MSG('Decrease font size'),TIP('Decrease font size'), |
               ICON('RtfLessFontSize.ico')
           PANEL,AT(157,21,1,14),USE(?TbPanel9),BEVEL(-1,1)
           BUTTON,AT(161,21,15,14),USE(?TbBold),SKIP,FLAT,MSG('Bold'),TIP('Bold'),ICON('RtfBold.ico')
           BUTTON,AT(177,21,15,14),USE(?TbItalic),SKIP,FLAT,MSG('Italic'),TIP('Italic'),ICON('RtfItalic.ico')
           BUTTON,AT(193,21,15,14),USE(?TbUnderline),SKIP,FLAT,MSG('Underline'),TIP('Undeline'),ICON('RtfUnderline.ico')
           PANEL,AT(213,21,1,14),USE(?TbPanel10),BEVEL(-1,1)
           BUTTON,AT(217,21,16,14),USE(?TbFont),SKIP,FLAT,MSG('Font'),TIP('Font'),ICON('RtfFont.ico')
           PANEL,AT(237,21,1,14),USE(?TbPanel11),BEVEL(-1,1)
           BUTTON,AT(241,21,17,14),USE(?TbJustlfyleft),SKIP,FLAT,MSG('Justify left'),TIP('Justify left'), |
               ICON('RtfLeft.ico')
           BUTTON,AT(261,21,17,14),USE(?TbJustiftCenter),SKIP,FLAT,MSG('Justify center'),TIP('Justify center'), |
               ICON('RtfCenter.ico')
           BUTTON,AT(279,21,17,14),USE(?TbJustiftRight),SKIP,FLAT,MSG('Justify right'),TIP('Justify right'), |
               ICON('RtfRight.ico')
           BUTTON,AT(383,21,17,14),USE(?TbOrderList),SKIP,FLAT,MSG('Order list'),TIP('Order list'),ICON('RtfOrder.ico')
           BUTTON,AT(401,21,17,14),USE(?TbUnOrderList),SKIP,FLAT,MSG('Bullet list'),TIP('Bullet list'), |
               ICON('RtfBullet.ico')
           PANEL,AT(378,21,1,14),USE(?TbPanel13),BEVEL(-1,1)
           BUTTON,AT(409,5,17,14),USE(?TbMakeAbsolute),SKIP,FLAT,MSG('Make absolute'),TIP('Make absolute'), |
               ICON('RtfAbsolute.ico')
           BUTTON,AT(342,21,16,14),USE(?TbOutdent),SKIP,FLAT,MSG('Indent left'),TIP('Indent left'),ICON('RtfIndentLeft.ico')
           BUTTON,AT(358,21,16,14),USE(?TbIndent),SKIP,FLAT,MSG('Indent right'),TIP('Indent right'),ICON('RtfIndentRight.ico')
           PANEL,AT(338,21,1,14),USE(?TbPanel15),BEVEL(-1,1)
           BUTTON,AT(302,21,16,14),USE(?TbBackColor),SKIP,FLAT,MSG('Background color'),TIP('Background color'), |
               ICON('RtfBackColor.ico')
           BUTTON,AT(318,21,16,14),USE(?TbFontColor),SKIP,FLAT,MSG('Font color'),TIP('Font color'),ICON('RtfForeColor.ico')
         END
       END
       TEXT,AT(0,0),USE(?Editor),FULL
     END

  CODE
        
  dhtmlocx=GETREG(REG_CLASSES_ROOT,'CLSID\{{2D360200-FFF5-11d1-8D03-00A0C959BC0A}\InprocServer32')
  if ~exists(clip(dhtmlocx)) ! 
     Message('Microsoft DHTML Editing ActiveX control is not installed.|Surf to https://www.microsoft.com/en-us/download/details.aspx?id=8956 and download it.','Error')
  end

  Open(Window)

  WindowHandle = SetWindowLong(Window{PROP:Handle},-4,Address(SubClassProc))

  OleHandle = ?Editor{PROP:Handle}

  HtmlEdit.Init(Window,?Editor,?ToolbarGroup,0,FALSE)
  HtmlEdit.FillFontsList(FontsQueue)

  HtmlEdit.SetWorkMode(heWORKMODE:Edit)
  HtmlEdit.SetToolbar(TRUE)

  Accept
    Case Event()
    Of EVENT:CloseWindow
      If Message('Are you sure ?','Exit',ICON:Question,BUTTON:YES + BUTTON:CANCEL,BUTTON:CANCEL,0) = BUTTON:YES
      Else
        Cycle
      End

    !Of EVENT:GainFocus
    !  HtmlEdit.Resume()

    !Of EVENT:LoseFocus
    !  HtmlEdit.Suspend()

    Of EVENT:MouseRightClick
      Case Popup('New|Open|Save As|-|Select All|-|Cut|Copy|Paste|-|Properties|')
      Of 1
        HtmlEdit.CreateNewDocument()
      Of 2
        HtmlEdit.LoadFromFile()
      Of 3
        HtmlEdit.SaveToFile()
      Of 4
        HtmlEdit.SelectAll()
      Of 5
        HtmlEdit.Cut()
      Of 6
        HtmlEdit.Copy()
      Of 7
        HtmlEdit.Paste()
      Of 8
        HtmlEdit.Properties()
      End

    Of EVENT:Changed
      FontsQueue.FontName = HtmlEdit.GetFontName()
      Get(FontsQueue,+FontsQueue.FontName)
      If Error()
        FontsQueue.FontName = ''
      Else
        ?TbFontsList{PROP:Selected} = Pointer(FontsQueue)
      End
      Display(?TbFontsList)

    Of EVENT:Copy
      HtmlEdit.Copy

    Of EVENT:Cut
      HtmlEdit.Cut

    Of EVENT:Paste
      HtmlEdit.Paste

    Of EVENT:Delete
      HtmlEdit.Delete

    Of EVENT:SelectAll
      HtmlEdit.SelectAll

    Of EVENT:Undo
      HtmlEdit.Undo

    Of EVENT:Redo
      HtmlEdit.Redo

    Of EVENT:Save
    End

    Case Accepted()
    OF ?TbNew
      HtmlEdit.CreateNewDocument()

    OF ?TbOpen
      If FileDialog('Choose File to edit',FileName,'HTML files|*.html|HTM files|*.htm',FILE:LongName + FILE:KeepDir)
        HtmlEdit.LoadFromFile(FileName)
      End

    OF ?TbSave
      HtmlEdit.SaveToFile(FileName)

    OF ?TbPrint
      HtmlEdit.PrintDocument(TRUE)

    OF ?TbCopy
      HtmlEdit.Copy()

    OF ?TbCut
      HtmlEdit.Cut()

    OF ?TbPaste
      HtmlEdit.Paste()

    OF ?TbUndo
      HtmlEdit.Undo()

    OF ?TbRedo
      HtmlEdit.Redo()

    OF ?TbLink
      HtmlEdit.HyperLink()

    OF ?TbImage
      HtmlEdit.Image()

    OF ?TbFind
      HtmlEdit.FindText()

    OF ?TbSelectAll
      HtmlEdit.SelectAll()

    OF ?TbProperties
      HtmlEdit.Properties()

    OF ?TbDelete
      HtmlEdit.Delete()

    OF ?TbLockElement
      HtmlEdit.LockElement()

    OF ?TbSendToBack
      HtmlEdit.SendToBack()

    OF ?TbBringToFront
      HtmlEdit.BringToFront()

    OF ?TbBringForward
      HtmlEdit.BringForward()

    OF ?TbSendBackward
      HtmlEdit.SendBackward()

    OF ?TbSendBehindText
      HtmlEdit.SendBelowText()

    OF ?TbInFrontOfText
      HtmlEdit.BringAboveText()

    OF ?TbFontsList
      Get(FontsQueue,Choice(?TbFontsList))
      If ~Error()
        HtmlEdit.SetFormat(FontsQueue.FontName)
        Select(?Editor)
      End

    OF ?TbIncreaseFontSize
      HtmlEdit.IncreaseFontSize()

    OF ?TbDecreaseFontSize
      HtmlEdit.DecreaseFontSize()

    OF ?TbBold
      HtmlEdit.SetFormat(,heFONTSTYLE:Bold)

    OF ?TbItalic
      HtmlEdit.SetFormat(,heFONTSTYLE:Italic)

    OF ?TbUnderline
      HtmlEdit.SetFormat(,heFONTSTYLE:Underline)

    OF ?TbFont
      HtmlEdit.Font()

    OF ?TbJustlfyleft
      HtmlEdit.Justifyleft()

    OF ?TbJustiftCenter
      HtmlEdit.JustifyCenter()

    OF ?TbJustiftRight
      HtmlEdit.JustifyRight()

    OF ?TbOrderList
      HtmlEdit.OrderList()

    OF ?TbUnOrderList
      HtmlEdit.UnOrderList()

    OF ?TbMakeAbsolute
      HtmlEdit.MakeAbsolute()

    OF ?TbOutdent
      HtmlEdit.OutDent()

    OF ?TbIndent
      HtmlEdit.Indent()

    OF ?TbBackColor
      HtmlEdit.SetBackColor()

    OF ?TbFontColor
      HtmlEdit.SetForeColor()
    End
  End

  HtmlEdit.Kill()

  Close(Window)

SubClassProc              PROCEDURE(hWnd,usMsg,wParam,lParam)

WM_KEYDOWN  Equate(0100h)
WM_KEYUP    Equate(0101h)

  CODE

  Case usMsg
  Of EVENT:Hook
    If GetFocus() = OleHandle
      If wParam = WM_KEYDOWN
        Case lParam
        Of 1
          Post(EVENT:Copy)
        Of 2
          Post(EVENT:Cut)
        Of 3
          Post(EVENT:Paste)
        Of 4
          Post(EVENT:Delete)
        Of 5
          Post(EVENT:SelectAll)
        Of 6
          Post(EVENT:Undo)
        Of 7
          Post(EVENT:Redo)
        Of 8                       !
          Post(EVENT:CloseWindow)  !
        Of 9
          Post(EVENT:Save)
        End
      End
    End
  End

  Return(CallWindowProc(WindowHandle,hWnd,usMsg,wParam,lParam))
