 Member
!Windows Marking Class
!Written by Jeff Slarve
!Copyright  1997 J&S Software Co.
!For use with Clarion 4 only (Previous versions will not work)

ShiftKey     Equate( 0100h )
CtrlKey      Equate( 0200h )
PgDnKey      Equate( 0022h )
PgUpKey      Equate( 0021h )
EndKey       Equate( 0023h )
HomeKey      Equate( 0024h )
CtrlEnd      Equate( 0223h )
CtrlHome     Equate( 0224h )
CtrlPgDn     Equate( 0222h )
CtrlPgUp     Equate( 0221h )
DownKey      Equate( 0028h )
UpKey        Equate( 0026h )
CtrlUp       Equate( 0226H )
CtrlDown     Equate( 0228H )


  Include('winmark.inc')

   map
   end
!:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
!Handles marking events
JSWinMark.EventHandler Procedure

  Code

    If Field() <> Self.ListBox then return(0).
    Case KeyCode()
    of CtrlPgDn orof CtrlPgUp orof CtrlUp orof CtrlDown
      Return(0)
    of CtrlEnd orof CtrlHome
      Self.UnMarkAll()
    end
    Case Event()
    of event:mousedown  !For whatever reason, this event seems to do it all...
       Self.m_CurrentRow = Self.ListBox{PROPList:MouseDownRow}
       If ~Band( KeyState(), CtrlKey )
          If Band( KeyState(), ShiftKey )
            Self.ShiftMark
            Get( Self.Q, Self.m_CurrentRow )
            Return(1)
          end
          Self.m_LastSelect = 0
          If Self.m_LastArrow !If the last action was just the movement of the arrow or page key.
            Self.UnMarkLastArrow()
          else
            Self.UnMarkAll()
          end
          Self.MarkSelected()
          Self.m_LastArrow = Self.m_LastSelect
       else
          If Band( KeyState(), ShiftKey )
            Self.ShiftMark
            Get( Self.Q, Self.m_CurrentRow )
            Return(1)
          end
          Self.MarkSelected()
          Self.m_LastArrow = 0
       end
       Return(1)
    else
       Self.m_CurrentRow = Self.ListBox{PROP:Selected}
    end
    Return(0)

!:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
!Shift-Marking behavior
JSWinMark.ShiftMark    Procedure
LOC:Ndx      Long
LOC:LastRow  Long
  Code
  Self.m_CurrentRow = Self.ListBox{PROP:Selected}
  LOC:LastRow = Choose(Self.m_LastSelect<>0,Self.m_LastSelect,Self.m_CurrentRow)
  Self.m_MarkParent = Choose( ~Self.m_MarkParent, Self.m_CurrentRow, Self.m_MarkParent )
  Loop LOC:Ndx = LOC:LastRow to Self.m_CurrentRow by Choose( LOC:LastRow > Self.m_CurrentRow, -1, 1 )
    Get( Self.Q, LOC:Ndx )
    Self.Mark = Choose( LOC:LastRow<>Self.m_CurrentRow, False, True )
    Put( Self.Q )
  end
  Loop LOC:Ndx = Self.m_CurrentRow  to Self.m_MarkParent by Choose( Self.m_MarkParent > Self.m_CurrentRow, 1, -1 )
    Get( Self.Q, LOC:Ndx )
    Assert( ~Errorcode() )
    Self.Mark = TRUE
    Put( Self.Q )
  end
  Self.m_LastSelect = Self.m_CurrentRow
  Self.m_LastArrow = 0

!:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
!Toggles the current selection
JSWinMark.MarkSelected Procedure
LOC:Ndx Long

  Code

  LOC:Ndx = Self.ListBox{PROP:Selected}
  Get( Self.Q, LOC:Ndx )
  Assert(~ErrorCode())
  Self.Mark = Choose( Self.Mark=1, 0, 1 )
  Put( Self.Q )
  Self.m_MarkParent = LOC:Ndx
  Self.m_LastSelect = LOC:Ndx
!:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
!Toggles the current selection
JSWinMark.UnMarkLastArrow Procedure
LOC:Ndx Long

  Code

  LOC:Ndx = Self.m_LastArrow
  Get( Self.Q, LOC:Ndx )
  Assert(~ErrorCode())
  Self.Mark = 0
  Put( Self.Q )
  Self.m_MarkParent = LOC:Ndx
  Self.m_LastSelect = LOC:Ndx

!:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
!Initializes the object
JSWinMark.Init PROCEDURE(window w, signed feq, queue Q, *Byte Mark, byte columns)
  CODE
    SELF.Q &= Q
    Self.Mark &= Mark
    SELF.ochanges = CHANGES(Q)
    Self.TQ &= New TestQueue
    Free(Self.TQ)
    Self.m_Columns = columns * 5
    SELF.CQ &= NEW ColQ
    Free( Self.CQ )
    Self.UMBG  = Color:White
    Self.UMFG  = Color:Black
    Self.UMSBG = Color:White
    Self.UMSFG = Color:Black
    Self.MBG   = Color:Navy
    Self.MFG   = Color:White
    Self.MSBG  = Color:Navy
    Self.MSFG  = Color:White
    Self.ListBox = FEQ
    Self.m_MarkParent = 0
    Self.m_LastArrow = 0
    w $ feq{PROP:vlbval} = ADDRESS(SELF)
    w $ feq{PROP:vlbproc} = ADDRESS(SELF.VLBproc)

!:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
JSWinMark.Kill Procedure
  Code
  Free(Self.CQ)
  Dispose(Self.CQ)
!:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
!A "server" for queue column info
JSWinMark.GetCol Procedure( Short Col, *String ColumnString )
ColorCol Long
  Code

  Self.CQ.Col = Col
  Get( Self.CQ, Self.CQ.Col )
  If ~ErrorCode()
    ColumnString = Format( Self.CQ.ReturnString, Self.CQ.Picture )
    Return(1)
  else
    If Self.Mark
      ColorCol = Choose( Col%5<>0, Col, 1 )
      Execute (ColorCol % 5)
        ColumnString = Self.MSBG
        ColumnString = Self.MFG
        ColumnString = Self.MBG
        ColumnString = Self.MSFG
      end
    else
      ColorCol = Choose( Col%5<>0, Col, 1 )
      Execute (ColorCol % 5)
        ColumnString = Self.UMSBG
        ColumnString = Self.UMFG
        ColumnString = Self.UMBG
        ColumnString = Self.UMSFG
      end
    end
    Return(1)
  end
  Return(0)

!:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
!Set the column queue
JSWinMark.SetCol Procedure( Short Col, *? ColumnString, String Picture )

  Code

  Clear( Self.CQ )
  Self.CQ.ReturnString &= NULL
  Self.CQ.Col = (Col * 5) - 4
  Self.CQ.Picture = Clip(Choose(Picture<>'',Picture, '@s20'))
  Self.CQ.ReturnString &= ColumnString
  Add( Self.CQ, Self.CQ.Col )
  Self.ListBox{PROPList:Color,Col}=1

!:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
!The Virtual ListBox Proc
JSWinMark.VLBproc PROCEDURE(long row, short col)
nchanges LONG
ColumnString String(300)
  CODE
    Self.TQ.Col = Col
    Get( Self.TQ, Self.TQ.COl )
    If ErrorCode()
      Self.Tq.Col = COl
      Add( Self.TQ, Self.TQ.COl)
    end

    CASE row
    OF -1     ! How many rows?
      RETURN RECORDS(SELF.Q)
    OF -2     ! How many columns?
      RETURN Self.m_Columns
    OF -3     ! Has it changed
      nchanges = CHANGES(SELF.Q)
      IF nchanges <> SELF.ochanges THEN
        SELF.ochanges = nchanges
        RETURN 1
      ELSE
        RETURN 0
      END
    ELSE
      GET(SELF.Q, row)
      If Self.GetCol( Col, ColumnString )
        Return( Clip( ColumnString ) )
      end
    END

!:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
!"Marks" all Records in the queue
JSWinMark.MarkAll Procedure
LOC:Ndx Long
  Code

  Loop LOC:Ndx = 1 to Records( Self.Q )
    Get( Self.Q, LOC:Ndx )
    Assert(~ErrorCode())
    If ~Self.Mark
      Self.Mark = True
      Put( Self.Q )
    end
  end
  Self.m_LastArrow = 0
  Display( Self.ListBox )

!:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
!"UnMarks" all Records in the queue
JSWinMark.UnMarkAll Procedure
LOC:Ndx Long
  Code

  Loop LOC:Ndx = 1 to Records( Self.Q )
    Get( Self.Q, LOC:Ndx )
    Assert(~ErrorCode())
    If Self.Mark
      Self.Mark = False
      Put( Self.Q )
    end
  end
  Self.m_LastArrow = 0
  Display( Self.ListBox )

!:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
JSWInMark.Reset         Procedure(<byte MarkFirstRecord>)

  Code

  Self.UnMarkAll()
  Self.ListBox{PROP:Selected} = 1
  Self.m_MarkParent=1
  Self.m_LastSelect=1
  Self.m_LastArrow=1
  Get( Self.Q, 1 )
  If ~ErrorCode()
    If MarkFirstRecord
      Self.Mark = True
      Put( Self.Q )
    end
  end