   program

IMAGE_BITMAP        EQUATE(0)
LR_DEFAULTSIZE      EQUATE(00040h)
LR_LOADFROMFILE     EQUATE(00010h)
RGN_OR              EQUATE(2)
HWND                EQUATE(UNSIGNED)

BITMAPGrp          GROUP,TYPE
bmType                LONG
bmWidth               LONG
bmHeight              LONG
bmWidthBytes          LONG
bmPlanes              LONG
bmBitsPixel           LONG
bmBits                LONG
                    END

    MAP
       MODULE('Windows API')
            CombineRgn(ULONG hRgnDest,ULONG hRgnSrc1,ULONG hRgnSrc2,LONG fnCombineMode),LONG,RAW,PASCAL,PROC,NAME('CombineRgn')
            CreateCompatibleDC(ULONG hDC),ULONG,RAW,PASCAL,NAME('CreateCompatibleDC')
            CreateRectRgn(LONG nLeftRect,LONG nTopRect,LONG nRightRect,LONG nBottomRect),ULONG,RAW,PASCAL,NAME('CreateRectRgn')
            DeleteDC(ULONG hDC),LONG,RAW,PASCAL,PROC,NAME('DeleteDC')
            DeleteObject(ULONG hgGDIObj),LONG,RAW,PASCAL,PROC,NAME('DeleteObject')
            GetDC(ULONG hWnd),ULONG,RAW,PASCAL,NAME('GetDC')
            GetLastError(),ULONG,PASCAL,RAW,NAME('GetLastError')
            GetObject(ULONG hgGDIObj,LONG cbBuffer,*BITMAPGrp lpvObject),LONG,RAW,PASCAL,PROC,NAME('GetObjectA')
            GetPixel(ULONG hDC,LONG nXPos,LONG nYPos),ULONG,RAW,PASCAL,NAME('GetPixel')
            LoadImage(UNSIGNED hInst,*CSTRING lpszIcon,ULONG uType,LONG cxDesired,LONG cyDesired,ULONG fuLoad),ULONG,RAW,PASCAL,NAME('LoadImageA')
            SelectObject(ULONG hDC,ULONG hgGDIObj),ULONG,RAW,PASCAL,PROC,NAME('SelectObject')
            SetWindowRgn(ULONG hWnd,ULONG hRgn,LONG bRedraw),LONG,RAW,PASCAL,PROC,NAME('SetWindowRgn')
            SendMessage(HWND,UNSIGNED,UNSIGNED,UNSIGNED),LONG,PASCAL,NAME('SendMessageA')
            ReleaseCapture(),BOOL,PASCAL
        END
    END

hBMP        ULONG
bm          LIKE(BITMAPGrp)
hWindowRgn  ULONG
hRgn        ULONG
hDC         ULONG
X           LONG
Y           LONG
XStart      LONG
TranCOLOR   LONG
bmpFile CSTRING(256)


Window WINDOW,AT(,,189,82),CENTER,TILED,GRAY,NOFRAME
       REGION,AT(0,0,149,80),USE(?Region:Drag)
       REGION,AT(151,42,37,38),USE(?Region:Close)
       BUTTON('Close'),AT(89,54,45,14),USE(?Close),FLAT,HIDE
       IMAGE('Splash256.bmp'),USE(?Image1),TILED
     END


    code
    OPEN(Window)
    DO MapWindowToBitmap
    
    ACCEPT
        CASE ACCEPTED()
            !OF ?Close
            !    POST(EVENT:CLOSEWINDOW)
            OF ?Region:Drag
                ReleaseCapture()
                lngReturnValue# = SendMessage(0{PROP:HANDLE},161,2,0)
            OF ?Region:Close
                HALT
        END
    END


MapWindowToBitmap   ROUTINE
  bmpFile = 'Splash256.bmp<0>'
  hBMP = LoadImage(SYSTEM{PROP:AppInstance},bmpFile,IMAGE_BITMAP,0,0,LR_LOADFROMFILE+LR_DEFAULTSIZE)
  IF NOT hBMP
    Message(hBMP & 'LE:' & GETLASTERROR() & ' ; '  & bmpFile)
    POST(EVENT:CLOSEWINDOW)
    EXIT
  END
  IF GetObject(hBMP,SIZE(bm),bm)
    Window{PROP:Width} = bm.bmWidth
    Window{PROP:Height} = bm.bmHeight
    hWindowRgn = CreateRectRgn(0,0,0,0)
    hDC = CreateCompatibleDC(GetDC(Window{PROP:Handle}))
    SelectObject(hDC,hBMP)
    TranCOLOR = GetPixel(hDC,0,0)
   ! MESSAGE(TranCOLOR & '/' & 0FF0000H)

    LOOP Y = 0 TO bm.bmHeight - 1
      LOOP X = 0 TO bm.bmWidth - 1
        IF GetPixel(hDC,X,Y) = TranCOLOR OR X=(bm.bmWidth - 1)
          IF XStart
            hRgn = CreateRectRgn(XStart,Y,X,Y+1);
            CombineRgn(hWindowRgn,hWindowRgn,hRgn,RGN_OR)
            IF hRgn
              DeleteObject(hRgn)
            END
          END
          XStart = 0
          CYCLE
        END
        IF ~XStart
            XStart = X
        END
      END
    END
    DeleteDC(hDC)
    SetWindowRgn(Window{PROP:Handle},hWindowRgn,TRUE)
  END
  DeleteObject(hBMP)
